from calibre.web.feeds.recipes import BasicNewsRecipe
class AdvancedUserRecipe1278063072(BasicNewsRecipe):
    title          = u'Singtao Daily - Canada'
    oldest_article = 7
    __author__ = 'rty'
    max_articles_per_feed = 100
    description = 'Toronto Canada Chinese Newspaper'
    publisher = 'news.singtao.ca'
    category = 'Chinese, News, Canada'
    remove_javascript = True
    use_embedded_content   = False
    no_stylesheets = True
    language = 'cn-HK'
    conversion_options = {'linearize_tables':True} 
    masthead_url = 'http://news.singtao.ca/i/site_2009/logo.jpg'
    extra_css = '''
        @font-face {font-family: "DroidFont", serif, sans-serif; 
	    src: url(res:///system/fonts/DroidSansFallback.ttf); }\n
		body {text-align: justify; margin-right: 8pt; font-family: 'DroidFont', serif;}\n
        h1 {font-family: 'DroidFont', serif;}\n
        .articledescription {font-family: 'DroidFont', serif;}
        '''
    keep_only_tags = [
	dict(name='div', attrs={'id':['title','storybody']}),
	dict(name='div', attrs={'class':'content'})
	]

    def parse_index(self):
            feeds = []
            for title, url in [
                ('Editorial 社論', 'http://news.singtao.ca/toronto/editorial.html'),
                ('Toronto 城市/社區', 'http://news.singtao.ca/toronto/city.html'),
                ('Canada 加國', 'http://news.singtao.ca/toronto/canada.html'),
                ('Entertainment 娛樂', 'http://news.singtao.ca/toronto/entertainment.html'),
                ('World 國際', 'http://news.singtao.ca/toronto/world.html'),
                ('Finance 財經', 'http://news.singtao.ca/toronto/finance.html'),
				('Sports 體育', 'http://news.singtao.ca/toronto/sports.html'),
                ]:
               articles = self.parse_section(url)
               if articles:
                   feeds.append((title, articles))
            return feeds
        
    def parse_section(self, url):
            soup = self.index_to_soup(url)
            div = soup.find(attrs={'class': ['newslist paddingL10T10','newslist3 paddingL10T10']})
            current_articles = []
            for li in div.findAll('li'):
                    a = li.find('a', href = True)
                    if a is None:
                        continue
                    title = self.tag_to_string(a)
                    url = a.get('href', False)
                    if not url or not title:
                        continue
                    if url.startswith('/'):
                         url = 'http://news.singtao.ca'+url
          #          self.log('\t\tFound article:', title)
          #          self.log('\t\t\t', url)
                    current_articles.append({'title': title, 'url': url, 'description':''})

            return current_articles

    def preprocess_html(self, soup):
        for item in soup.findAll(style=True):
           del item['style']
        for item in soup.findAll(width=True):
           del item['width']
        return soup